/**
 * 调用通用组件
 */
new KS_Main();

/**
 * 标题配置
 */
function setPageTitle(parameter){
	if(typeof parameter === 'string'){
		parameter = {
			title:parameter
		}
	}
	var title = parameter.title;
	$('#header').find('.text').html(title);
	$('#header').find('.backicon').click(function(){
		// if(localStorage.backUrl){
		// 	openUrl()
			
		// }else if(parameter.back && parameter.back !== -1){
		// 	location.href = parameter.back
		// }else{
		// 	history.back(-1)
		// }

		history.back(-1)
	})
	
};

/**
 * 打开链接
 */
function openUrl(url){
	if(url){
		/**
		 * 将上一页地址存入本地缓存
		 */
		localStorage.backUrl = location.href;
		location.href = url;
	}else if(localStorage.backUrl){
		/**
		 * 打开本地缓存的链接
		 */
		var backUrl = localStorage.backUrl;
		localStorage.backUrl = '';
		location.href = backUrl;
		
	}
}

/**
 * 重写返回方法
 */
// if (window.history && window.history.pushState) {
// 	$(window).on('popstate', function () {
// 		if(localStorage.backUrl){
// 			openUrl()
// 		}else{
// 			history.back(-1)
// 		}
// 	});
// }

// window.history.pushState('forward', null, ''); 
// window.history.forward(1);

 
/**
 * 设置个人中心头部
 */
function setUserPageTitle(title){
	setPageTitle({
		title:title,
		back:'/user'
	})
};

/**
 * 打开页面
 */
function openNewPage(id){
	var $page = $('#'+id);
	var $default = $('page-default');
	$page.attr('style','display:block;width:100%;height:100%;position:fixed;right:-'+window.innerWidth+'px;top:0;z-index:9999;').animate({
		right:0
	},400);
	$page.find('[page-fixed]').css({
		left:'inherit',
		right:-window.innerWidth
	}).animate({
		right:0
	},400)
	$default.find('[page-fixed]').animate({
		left:-window.innerWidth
	},400);
	$default.animate({
		left:-window.innerWidth
	},400,function(){
		$default.hide()
		$page.attr('style','display:block')
	})
}

/**
 * 关闭页面
 */
function closePage(id){
	var $page = $('#'+id);
	var $default = $('page-default');
	$page.animate({
		right:-window.innerWidth
	},400);
	$page.find('[page-fixed]').animate({
		right:-window.innerWidth
	},400)
	$default.attr('style','display:block;width:100%;height:100%;position:fixed;left:-'+window.innerWidth+'px;top:0;z-index:9999;').animate({
		left:0
	},400);
	$default.find('[page-fixed]').animate({
		left:0
	},400,function(){
		$page.hide();
		$default.attr('style','display:block')
	});
}


(function(oldIndex,toggleFlag,$headNavTarget){
	
	$(window).resize(function(){
		$('[page-fixed]').width(window.innerWidth)
	}).resize();
	/**
	 * 获取用户信息
	 */
	getUserInfo(function(res){
		$('#header').find('.images-bg').css({
			backgroundImage:'url(/UploadFiles/avatar/' + res.userid + '.jpg)'
		});
		$('#header').find('.username').html(res.username).parent().attr('onclick','location.href=\'/user\'');
		if(res.message != 0){
			$('#header').find('.tips-dot').show();
			$('.message-num').html(res.message).show()
		}
		$('#goUserIndex').attr('onclick','location.href=\'/user\'')
	},function(res){
		$('#goUserIndex').attr('onclick','location.href=\''+res.url_login+'\'')
	});

	/**
	 * SQL标签异步赋值
	 */
	$('.SQL_async').each(function(){
		this.outerHTML = this.value
	})

	var navel = document.querySelector('.tytab') || document.querySelector('.SchoolNav')
	if(navel){
		
		var $navel = $(navel);
		var $curel = $navel.find('.curr');
		var x = $curel.offset().left + $curel.width() - window.innerWidth;
		var nextLength = $curel.nextAll('li').length;
		if(nextLength >= 2){
			x += $curel.width() * 2;
		}else if(nextLength >= 1){
			x += $curel.width();
		}
		x = Math.max(x,0);
		$navel.find('.swiper-wrapper').css({
			transform:'translate3d(-'+x+'px, 0px, 0px)'
		})
	}

	/**
	 * 打开头部菜单
	 */
	window.toggleHeaderNav = function(el){

		$headNavTarget = $(el).next();
		if(toggleFlag){
			if($headNavTarget.css('display') === 'none'){
				headerNavAnimate(0.05,1)
			}else{
				headerNavAnimate(0.95,0)
			}
			
		}
	}

	/**
	 * 点击任何区域关闭头部菜单
	 */
	$(document).click(function(){
		if($headNavTarget && $headNavTarget.css('display') === 'block' && toggleFlag){
			headerNavAnimate(0.95,0)
		}
	})

	/**
	 * 头部菜单打开动画
	 */
	function headerNavAnimate(num,flag){
		
		toggleFlag = false;
		if(flag){
			$headNavTarget.css({
				display:'block',
				transformOrigin:'100% 0',
				opacity:num,
				transform:'scale('+num+')'
			});
			if(num<1){
				setTimeout(function(){
					headerNavAnimate(num+0.05,flag)
				},10)
			}else{
				toggleFlag = true
			}
		}else{
			$headNavTarget.css({
				transformOrigin:'100% 0',
				opacity:num,
				transform:'scale('+num+')'
			});
			if(num <= 0){
				toggleFlag = true
				$headNavTarget.hide();
			}else{
				setTimeout(function(){
					headerNavAnimate(num-0.05,flag)
				},10)
			}
		}
	}

	/**
	 * 分类下拉
	 */
	$(".filertbox").on('click','dt',function(){
		var i = $(this).index();
		if(i!=oldIndex){
			oldIndex = i;
			$(this).addClass('curr').siblings().removeClass('curr')
			$(this).find('.ksicon').addClass("iconrotate");
			$(this).siblings().find('.ksicon').removeClass("iconrotate");
			$("#myfilertbg").fadeIn(300)
			$("#myfilert").find(".box:eq("+i+")").fadeIn(300).siblings().hide();
			
		}else{
			closeFilert();
			oldIndex = -1;
		};
	});
	$('#myfilertbg').click(function(){
	   closeFilert();
	});
	
	function closeFilert(){
		$(".filertbox").find('dt').removeClass('curr');
	    $(".filertbox").find('.ksicon').removeClass("iconrotate");
		$("#myfilertbg").fadeOut(300)
		$("#myfilert").find(".box").fadeOut(300);
		
	};
	/**
	 * 获取选中信息
	 */
	$('#myfilert').find('.box').each(function(index) {
        var currText = $(this).find(".curr").text();
		var type = $(this).find('li').attr('field');
		if(type=='price_member' && (currText == '不限' || currText=='')){
			currText = $(".filertbox").find('dt').eq(index).find('span').text();
		};
		$(".filertbox").find('dt').eq(index).find('span').html(currText);
		
	});
})(-1,true);
